/*
 * @(#)OMBshView.java  1.0  2006-06-18
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 *
 */
package ch.hslu.cm.oo;

import ch.hslu.cm.oo.objectmodelbsh.*;
import java.awt.*;
import java.beans.*;
import java.io.*;
import java.lang.reflect.*;
import java.net.URI;
import java.util.LinkedList;
import javax.swing.*;
import javax.swing.border.*;
import org.jhotdraw.app.*;
import org.jhotdraw.app.action.edit.RedoAction;
import org.jhotdraw.app.action.edit.UndoAction;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.action.*;
import org.jhotdraw.draw.io.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.io.ImageOutputFormat;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.gui.*;
import org.jhotdraw.undo.*;
import org.jhotdraw.xml.*;

/**
 * A drawing project for class diagrams.
 *
 * @author Werner Randelshofer
 * @version 1.0 2006-06-18 Created.
 */
public class OMBshView extends AbstractView {
   
    /**
     * Each OMBshView uses its own undo redo manager.
     * This allows for undoing and redoing actions per project.
     */
    private UndoRedoManager undo;
    
    /**
     * Depending on the type of an application, there may be one editor per
     * project, or a single shared editor for all projects.
     */
    private DrawingEditor editor;
    
    /**
     * Creates a new Project.
     */
    public OMBshView() {
        initComponents();
        }
    @Override
    public void init() {
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        scrollPane.setLayout(new PlacardScrollPaneLayout());
        scrollPane.setBorder(new EmptyBorder(0,0,0,0));
        
        setEditor(new DefaultDrawingEditor());

        undo = new UndoRedoManager();
        view.setDrawing(createDrawing());
        view.getDrawing().addUndoableEditListener(undo);
        initActions();
        undo.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setHasUnsavedChanges(undo.hasSignificantEdits());
            }
        });
        
        org.jhotdraw.util.ResourceBundleUtil labels = org.jhotdraw.util.ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        
        JPanel placardPanel = new JPanel(new BorderLayout());
        javax.swing.AbstractButton pButton;
        pButton = ButtonFactory.createZoomButton(view);
        pButton.putClientProperty("Quaqua.Button.style","placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin",new Insets(0,0,0,0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add(pButton, BorderLayout.WEST);
        pButton = ButtonFactory.createToggleGridButton(view);
        pButton.putClientProperty("Quaqua.Button.style","placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin",new Insets(0,0,0,0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "view.toggleGrid.placard");
        placardPanel.add(pButton, BorderLayout.EAST);
        scrollPane.add(placardPanel, JScrollPane.LOWER_LEFT_CORNER);
    }

    private Drawing createDrawing() {
       ClassDiagram drawing= new ClassDiagram(new ObjectModelBsh());
       setIOFormats(drawing);
       return drawing;
    }

    private void setIOFormats(Drawing drawing) {
        DOMStorableInputOutputFormat domIOF = new DOMStorableInputOutputFormat(new OMBshFactory());
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(domIOF);
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(domIOF);
        outputFormats.add(new ImageOutputFormat());
        drawing.setInputFormats(inputFormats);
        drawing.setOutputFormats(outputFormats);
    }
    
    public DrawingEditor getEditor() {
        return editor;
    }
    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = editor;
        if (oldValue != null) {
            oldValue.remove(view);
        }
        editor = newValue;
        if (newValue != null) {
            newValue.add(view);
        }
    }
    
    /**
     * Initializes project specific actions.
     */
    private void initActions() {
        ActionMap am=getActionMap();
        am.put(UndoAction.ID, undo.getUndoAction());
        am.put(RedoAction.ID, undo.getRedoAction());
    }
    @Override
    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        undo.setHasSignificantEdits(newValue);
    }
    
    /**
     * Writes the project to the specified file.
     */
    @Override
    public void write(URI f, URIChooser chooser) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File(f))));
            OutputFormat outFormat = view.getDrawing().getOutputFormats().get(0);
            outFormat.write(f, view.getDrawing());
        } finally {
            //if (out != null) try { out.close(); } catch (IOException e) {};
            if (out != null) out.close();
        }
    }
    
    /**
     * Reads the project from the specified file.
     */
    @Override
    public void read(URI f, URIChooser chooser) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(new File(f)));
            NanoXMLDOMInput domi = new NanoXMLDOMInput(new OMBshFactory(), in);
            if (domi.getElementCount("ConceptModelerOO")>0) {
            domi.openElement("ConceptModelerOO");
            
            
            final String chapterText;
            if (domi.getElementCount("Chapter") > 0) {
                domi.openElement("Chapter");
                chapterText = (String) domi.readObject();
                domi.closeElement();
            } else {
                chapterText = "";
            }
            final String titleText;
            if (domi.getElementCount("Title") > 0) {
                domi.openElement("Title");
                titleText = (String) domi.readObject();
                domi.closeElement();
            } else {
                titleText = "";
            }
            final String instructionsText;
            if (domi.getElementCount("Instructions") > 0) {
                domi.openElement("Instructions");
                instructionsText = (String) domi.readObject();
                domi.closeElement();
            } else {
                instructionsText = "";
            }
            }
               final ClassDiagram diagram;
               Object obj0=domi.readObject(0);
               if (obj0 instanceof ClassDiagram) {
               diagram = (ClassDiagram) obj0;
               } else {
                ObjectModelBsh model = (ObjectModelBsh)obj0;
               diagram = (ClassDiagram)domi.readObject(1);
                diagram.putSimulation(model);
               }
               setIOFormats(diagram);
               /*
               
            // XXX - Implement problem and solution diagram
            /*
            final ConceptualERDiagram pDiagram;
            if (domi.getElementCount("Problem") > 0) {
                domi.openElement("Problem");
                ConceptualERModel pSimulation = (ConceptualERModel) domi.readObject(0);
                pDiagram = (ConceptualERDiagram) domi.readObject(1);
                domi.closeElement();
            } else {
                pDiagram = new ConceptualERDiagram();
            }
            final ConceptualERDiagram sDiagram;
            if (domi.getElementCount("Solution") > 0) {
                domi.openElement("Solution");
                ConceptualERModel sSimulation = (ConceptualERModel) domi.readObject(0);
                sDiagram = (ConceptualERDiagram) domi.readObject(1);
                domi.closeElement();
                domi.closeElement();
            } else {
                sDiagram = new ConceptualERDiagram();
            }
            final String language;
            if (domi.getElementCount("Language") > 0) {
                domi.openElement("Language");
                language = (String) domi.readObject();
                domi.closeElement();
            } else {
                language = "en";
            }*/
            
            SwingUtilities.invokeAndWait(new Runnable() {     @Override
public void run() {
                // XXX - Implement problem and solution diagram
                view.getDrawing().removeUndoableEditListener(undo);
                view.setDrawing(diagram);
                view.getDrawing().addUndoableEditListener(undo);
                /*
                problemDrawingView.getDrawing().removeUndoableEditListener(undo);
                solutionDrawingView.getDrawing().removeUndoableEditListener(undo);
                problemDrawingView.setDrawing(pDiagram);
                solutionDrawingView.setDrawing(sDiagram);
                problemDrawingView.getDrawing().addUndoableEditListener(undo);
                solutionDrawingView.getDrawing().addUndoableEditListener(undo);
                optionsPanel.setChapterText(chapterText);
                optionsPanel.setTitleText(titleText);
                optionsPanel.setInstructionsText(instructionsText);
                optionsPanel.setInstructionLanguage(new Locale(language));
                 */
                undo.discardAllEdits();
            }});
        } catch (InterruptedException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        } catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        } catch (Throwable e) {
            IOException error = new IOException("Error: "+e.getMessage());
            error.initCause(e);
            throw error;
        } finally {
            if (in != null) try { in.close(); } catch (IOException e) {};
        }
        /*
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            NanoXMLLiteDOMInput domi = new NanoXMLLiteDOMInput(view.getDOMFactory(), in);
            domi.openElement("ConceptModelerOO");
            final ClassDiagram drawing = (ClassDiagram) domi.readObject();
            domi.closeElement();
            SwingUtilities.invokeAndWait(new Runnable() { public void run() {
                view.getDrawing().removeUndoableEditListener(undo);
                view.setDrawing(drawing);
                view.getDrawing().addUndoableEditListener(undo);
                undo.discardAllEdits();
            }});
        } catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        } catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        } finally {
            if (in != null) try { in.close(); } catch (IOException e) {};
        }*/
    }
    
    /**
     * Sets a drawing editor for the project.
     */
    public void setDrawingEditor(DrawingEditor newValue) {
        if (editor != null) {
            editor.remove(view);
        }
        editor = newValue;
        if (editor != null) {
            editor.add(view);
        }
    }
    
    /**
     * Gets the drawing editor of the project.
     */
    public DrawingEditor getDrawingEditor() {
        return editor;
    }
    
    /**
     * Clears the project.
     */
    @Override
    public void clear() {
        if (view.getDrawing()!=null) {
            view.getDrawing().removeUndoableEditListener(undo);
        }
        view.setDrawing(createDrawing());
        undo.discardAllEdits();
        view.getDrawing().addUndoableEditListener(undo);
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        view = new org.jhotdraw.draw.DefaultDrawingView();

        setLayout(new java.awt.BorderLayout());

        scrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        scrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        scrollPane.setViewportView(view);

        add(scrollPane, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane scrollPane;
    private org.jhotdraw.draw.DefaultDrawingView view;
    // End of variables declaration//GEN-END:variables
    
}
